
// Processing GUI Code for Laptop-Based HMI for DC Motor Speed and Direction Control
// Author: Pradipta Ghosh

import processing.serial.*;



////////////////////////    Globle Variable  /////////////////////////////////////
Serial myPort ;
String status = "stop";
int speed = 3; // Initial minimum speed
int control = 315; // Initial slider position

////////////////////////    setup  /////////////////////////////////////

void setup()
{

  size(500, 380);
  background(0);
  textSize(16);
  fillgreen();
  text("LaptoHMI_Laptop-Based HMI for DC Motor Speed and Direction Control", 10, 15);
  myPort = new Serial(this, "COM3", 9600); // My Arduino is Connected to COM3 , Edit this as per your Arduino connected port
  myPort.bufferUntil('\n');
  text("Serial Port : COM3", 40, 350);
  stroke(0, 255, 0);
  line(0, 20, 500, 20);

  

  speedControl();
  
  forwardButton();
  stopButton();
  reverseButton();

  stopStatus();
}


////////////////////////    draw  ////////////////////////////////////////////
void draw()
{
  if ((mousePressed == true) && (mouseX>40 && mouseX<80) && (mouseY>40 && mouseY<80))
  {
    forwardButtonPressed();
    myPort.write(0); // Command 0 for selection of Forward mode.
    control = 315; // Resetting the Control bar
    speed = 3; // Resetting the speed
  } else if (mousePressed==false) forwardButton();

  if ((mousePressed == true) && (mouseX>160 && mouseX<200) && (mouseY>40 && mouseY<80))
  {
    stopButtonPressed();
    myPort.write(1); // Command 1 for selection of Stop.
    control = 315; // Resetting the Control bar
    speed = 3; // Resetting the speed
  } else if (mousePressed==false) stopButton();

  if ((mousePressed == true) && (mouseX>280 && mouseX<320) && (mouseY>40 && mouseY<80))
  {
    reverseButtonPressed();
    myPort.write(2); //Command 2 for selection of reverse mode.
    control = 315; // Resetting the Control bar
    speed = 3; // Resetting the speed
  } else if (mousePressed==false) reverseButton();
  speedControl();
}




////////////////////////    forward button  /////////////////////////////////////

void forwardButton()
{
  // outer circle
  fillblack();
  stroke(0, 255, 0);
  circle( 60, 60, 50);

  // inner circle
  fillgreen();
  stroke(0);
  circle( 60, 60, 40);

  //nomenculture of button
  textSize(16);
  text("Forward", 33, 110);
}

void forwardButtonPressed()
{
  //inner circle
  fillblack();
  stroke(0);
  circle( 60, 60, 40);
  fillgreen();
  stroke(0, 255, 0);
  circle( 60, 60, 30);
  forwardStatus();
}



////////////////////////    stop button  /////////////////////////////////////

void stopButton()
{
  // outer circle
  fillblack();
  stroke(255, 0, 0);
  circle( 180, 60, 50);

  // inner circle
  fillred();
  stroke(0);
  circle( 180, 60, 40);

  //nomenculture of button
  textSize(16);
  fillred();
  text("Stop", 163, 110);
}

void stopButtonPressed()
{
  // inner circle
  fillblack();
  stroke(0);
  circle( 180, 60, 40);
  fillred();
  stroke(255, 0, 0);
  circle( 180, 60, 30);
  stopStatus();
}



////////////////////////    reverse button  /////////////////////////////////////

void reverseButton()
{
  // outer circle
  fillblack();
  stroke(0, 255, 0);
  circle( 300, 60, 50);

  // inner circle
  fillgreen();
  stroke(0);
  circle( 300, 60, 40);

  //nomenculture of button
  textSize(16);
  fillgreen();
  text("Reverse", 275, 110);
}

void reverseButtonPressed()
{
  // outer circle
  fillblack();
  stroke(0);
  circle( 300, 60, 40);
  fillgreen();
  stroke(0, 255, 0);
  circle( 300, 60, 30);
  reverseStatus();
}



////////////////////////    stop Status  /////////////////////////////////////

void stopStatus()
{
  fillblack();
  stroke(0, 255, 0);
  circle( 180, 160, 70);

  // inner circle
  fillblack();
  stroke(0, 255, 0);
  circle( 180, 160, 30);

  //nomenculture of button
  textSize(16);
  fillblack();
  stroke(0,0,0);
  rect(120, 205, 140, 20);
  fillred();
  text("Status : Stop", 135, 220);

  translate(180, 160);
  for ( int i = 0; i < 20; i++)
  {
    fillred();
    noStroke();
    rect(17, 0, 15, 5); // For Forward
    rotate( (TWO_PI )/ 10.0 );
  }
}

////////////////////////    forward Status  /////////////////////////////////////

void forwardStatus()
{

  fillblack();
  stroke(0, 255, 0);
  circle( 180, 160, 70);

  // inner circle
  fillblack();
  stroke(0, 255, 0);
  circle( 180, 160, 30);

  //nomenculture of button
  textSize(16);
  fillblack();
  stroke(0,0,0);
  rect(120, 205, 140, 20);
  fillgreen();
  text("Status : Forward", 135, 220);

  translate(180, 160);
  for ( int i = 0; i < 20; i++)
  {
    quad(0, 16, -5, 22, 0, 33, -10, 22); // For Forward
    rotate( (TWO_PI )/ 7.0 );
  }
}


////////////////////////    reverse Status  /////////////////////////////////////

void reverseStatus()
{
  // outer circle
  fillblack();
  stroke(0, 255, 0);
  circle( 180, 160, 70);

  // inner circle
  fillblack();
  stroke(0, 255, 0);
  circle( 180, 160, 30);

  //nomenculture of button
  textSize(16);
  fillblack();
  stroke(0,0,0);
  rect(120, 205, 140, 20);
  fillgreen();
  text("Status : Reverse", 135, 220);

  translate(180, 160);
  for ( int i = 0; i < 20; i++)
  {
    quad(0, 16, 5, 22, 0, 33, 10, 22); // For Reverse
    rotate( (TWO_PI )/ 7.0 );
  }
}

////////////////////////    Speed Control  /////////////////////////////////////

void speedControl()
{

  fillblack();
  stroke(0, 255, 0);
  rect(360, 20, 140, 360); // speed control box
  fillgreen();
  text("Speed Max", 390, 40);
  text("Speed Min", 390, 350);

  fillgreen();
  stroke(0, 255, 0);
  rect(420, 60, 10, 252);
  rect(380, control-10, 90, 20, 28);
  /////////////////////////////////Speed Controller///////////////
  speed = 318-control; // 3 to 255
  myPort.write(speed);

  if ((mousePressed == true) && (mouseX>380 && mouseX<470) /*&& /*(mouseY>305 && mouseY<325)*/)
  {
    //fillgreen();
    stroke(0, 255, 0);
    control = mouseY;
    if (mouseY>315) control = 315;
    if (mouseY<63) control = 63;
    rect(380, control-10, 90, 20, 28);
    speed = 318-control; // 3 to 255
    myPort.write(speed);
  }
  fillblack();
  
}

/////////////////////////////// Colour ///////////////////////////////
void fillgreen()
{
  fill(0, 255, 0);
}

void fillred()
{
  fill(255, 0, 0);
}
void fillwhite()
{
  fill(255);
}
void fillblack()
{
  fill(0);
}
